#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/jrb/header.h"
extern u8 _jrb_segment_ESegmentRomStart[];
extern u8 _jrb_segment_ESegmentRomEnd[];

const LevelScript level_jrb_entry[] = {
INIT_LEVEL(),
LOAD_RAW(0x0E, _jrb_segment_ESegmentRomStart, _jrb_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group3_mio0SegmentRomStart, _group3_mio0SegmentRomEnd),
LOAD_RAW(12, _group3_geoSegmentRomStart, _group3_geoSegmentRomEnd),
LOAD_MIO0(6, _group13_mio0SegmentRomStart, _group13_mio0SegmentRomEnd),
LOAD_RAW(13, _group13_geoSegmentRomStart, _group13_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
// LOAD_MODEL_FROM_GEO(226, 0x07007070),
// LOAD_MODEL_FROM_GEO(227, 0x07008dc0),
// LOAD_MODEL_FROM_GEO(228, 0x0700a090),
// LOAD_MODEL_FROM_GEO(229, 0x0700bfe0),
// LOAD_MODEL_FROM_GEO(230, 0x0700e3d0),
// LOAD_MODEL_FROM_GEO(231, 0x0700efd0),
// LOAD_MODEL_FROM_GEO(232, 0x07010780),
// LOAD_MODEL_FROM_GEO(233, 0x07011ab0),
// LOAD_MODEL_FROM_GEO(249, 0x07004a10),
// LOAD_MODEL_FROM_GEO(250, 0x07002a20),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_4),
JUMP_LINK(script_func_global_14),
JUMP_LINK(local_area_jrb_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_jrb_1_[] = {
AREA(1, Geo_jrb_1_0x13e9770),
TERRAIN(col_jrb_1_0xe071230),
SET_BACKGROUND_MUSIC(0, 55),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_jrb_1_),
JUMP_LINK(local_warps_jrb_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_jrb_1_[] = {
OBJECT_WITH_ACTS(0, 96, 1110, 7349, 0, 180, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(223, 6256, 247, -3339, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(188, 6936, 247, -4030, 0, 180, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(195, 5814, 2161, 3517, 0, 0, 0, 0xf0000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(201, 5606, 2164, 3570, 0, 0, 0, 0xba0000,  bhvCannonClosed, 31),
OBJECT_WITH_ACTS(195, 6892, 985, -3807, 0, 0, 0, 0x0,  bhvBobombBuddyOpensCannon, 31),
OBJECT_WITH_ACTS(122, 96, 4864, 7304, 0, 180, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(137, -6803, 1324, -3262, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, 96, 994, -3474, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(86, 96, 3251, -3154, 0, 180, 0, 0x0,  bhvKingBobomb, 31),
OBJECT_WITH_ACTS(188, 133, 1, 2088, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(137, -6819, 454, 1331, 0, 0, 0, 0x40000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -6819, 454, 1014, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -6819, 454, 678, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -6819, 64, 678, 0, 0, 0, 0xf0000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -6819, 64, 1014, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -6819, 64, 1331, 0, 0, 0, 0x70000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(22, 1170, 1, 3221, 0, 90, 0, 0x140000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, 4508, 1760, 616, 0, 0, 0, 0x130000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, -1277, 1, 3188, 0, 270, 0, 0x160000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, -4309, 1760, 503, 0, 0, 0, 0x150000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, 96, 2251, 684, 0, 0, 0, 0x180000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, 96, 3045, 684, 0, 180, 0, 0x170000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(24, 6817, 1, -2257, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(0, 6881, 451, -326, 0, 0, 0, 0x0,  bhvHidden1upInPoleSpawner, 31),
OBJECT_WITH_ACTS(24, 6881, 1, -326, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(140, -3639, 1, -6357, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, -2440, 51, -6361, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -1048, 51, -6361, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 352, 51, -6361, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 1832, 51, -6361, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 3232, 51, -6361, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(24, -6625, 1, -571, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(24, -6606, 1, -2400, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(0, 96, 2164, 3206, 0, 0, 0, 0x4000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(201, -5423, 2211, 3542, 0, 180, 0, 0xba0000,  bhvCannonClosed, 31),
OBJECT_WITH_ACTS(215, -6629, 51, 3096, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(129, -4113, 1, 2252, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(130, -4069, 1, 1261, 0, 0, 0, 0x0,  bhvBreakableBoxSmall, 31),
OBJECT_WITH_ACTS(129, -6791, 1, 1834, 0, 0, 0, 0x30000,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(212, -6837, 873, 997, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, -5425, 1, 2172, 0, 180, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(215, 6865, 351, -1173, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -6597, 351, -1491, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 4352, 1035, -4000, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 6914, 938, 3218, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5457, 365, -4664, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 96, 1910, -5648, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 96, 1615, -3445, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(129, -5477, 1, 2765, 0, 0, 0, 0x20000,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, -4628, 1, 2618, 0, 0, 0, 0x10000,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(0, 96, 1, 843, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 5601, 1760, -1854, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -5429, 1760, -1593, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 1358, 1100, -2991, -22, 38, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -1253, 1100, -2884, -22, -40, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(188, 96, 2251, 1040, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 1146, 1, -1315, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -1348, 1, -1332, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(223, -6740, 1, -1310, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 6830, 1, -1171, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(0, 0, -3032, 0, 0, 0, 0, 0x5000000,  bhvTreasureChestsJrb, 31),
OBJECT_WITH_ACTS(223, 5223, 1760, 2121, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 930, 1760, -5604, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(188, 6029, 1760, 1379, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -5088, 1760, 1585, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 5580, 1760, -1432, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(0, -5365, 1760, -3933, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(192, 4763, 1760, -4862, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, 4985, 247, -5823, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, -5400, 1760, -714, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(188, 2213, 1517, -1220, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -2110, 1511, -1220, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 4304, 1, -1272, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -260, 1, -4410, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 3368, 1, -5488, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -3320, 1, -1286, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(0, 96, 1, -5508, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -5455, 1, -1442, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 5607, 1, -1442, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(188, 699, 1, 3795, 0, 0, 0, 0x10000,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -616, 1, 3795, 0, 0, 0, 0x10000,  bhvBobomb, 31),
OBJECT_WITH_ACTS(0, 80, 1, -2963, 0, 180, 0, 0x6c0000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(0, -1137, -3023, 2657, 0, 90, 0, 0x6b0000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(188, 3419, 1760, 3207, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(180, -887, 3454, -2169, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 1074, 3454, -2169, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -887, 3454, -156, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 1074, 3454, -156, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(195, -5711, 1, 694, 0, 0, 0, 0x200000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(195, 4718, 1, 2424, 0, 0, 0, 0x230000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(195, 5857, 1, 1687, 0, 0, 0, 0x230000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(195, 5854, 1, 2558, 0, 0, 0, 0x230000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(195, 6551, 1, 2375, 0, 0, 0, 0x20000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(195, 6516, 1, 1135, 0, 0, 0, 0x10000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(195, -6057, 1, -4662, 0, 90, 0, 0x30000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(195, 4723, 1, 1670, 0, 0, 0, 0x230000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(195, -5231, 2208, 3552, 0, 0, 0, 0x100000,  bhvBobombBuddy, 31),
OBJECT_WITH_ACTS(226, 0, -3003, -100, 0, 0, 0, 0x0,  Bhv_Custom_0x13005714, 31),
OBJECT_WITH_ACTS(192, -5516, 0, 7264, 0, 90, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(0, -3076, 75, 6653, 0, 90, 0, 0x100000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 5320, 75, 6972, 0, 0, 0, 0x120000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(223, 2683, 0, 6661, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(212, -8430, 3814, 7917, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(212, 8500, 3814, 4137, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(124, 1073, -3030, 2656, 0, 270, 0, 0x80000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(122, 6901, -50, 2433, -90, 0, 0, 0x1000000,  bhvStar, 31),
RETURN()
};

const LevelScript local_warps_jrb_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(20, 12, 1, 19, 0),
WARP_NODE(19, 12, 1, 20, 0),
WARP_NODE(22, 12, 1, 21, 0),
WARP_NODE(21, 12, 1, 22, 0),
WARP_NODE(24, 12, 1, 23, 0),
WARP_NODE(23, 12, 1, 24, 0),
WARP_NODE(104, 12, 1, 26, 0),
WARP_NODE(26, 12, 1, 104, 0),
WARP_NODE(28, 12, 1, 27, 0),
WARP_NODE(27, 12, 1, 28, 0),
WARP_NODE(107, 12, 1, 108, 0),
WARP_NODE(108, 12, 1, 107, 0),
WARP_NODE(240, 6, 1, 43, 0),
WARP_NODE(241, 6, 1, 53, 0),
RETURN()
};
